<?php

namespace Hellohostcp\quoteshellarg;

function quoteshellarg(string|int|float $arg): string {
    if (is_float($arg)) {
        // Format floats to 17 significant digits to preserve precision
        $arg = sprintf('%.17g', $arg);
    }
    if (is_int($arg)) {
        $arg = (string)$arg;
    }

    // Detect OS
    $os = PHP_OS_FAMILY;

    // Unix-like systems
    if (in_array($os, ['Linux', 'BSD', 'Darwin', 'Solaris', 'Cygwin'], true)) {
        // PHP's built-in escapeshellarg() for unix is kindof garbage
        // It corrupts UTF-8 characters and strips non-printable characters
        // that are actually legal in shell arguments

        // For unix, we only need to handle:
        // 1. Null bytes (which we can't allow)
        // 2. Single quotes (escaped as '\'')

        if (str_contains($arg, "\0")) {
            throw new \InvalidArgumentException('Argument contains null byte');
        }

        // Single quote the whole thing, escaping any existing single quotes
        return "'" . str_replace("'", "'\\''", $arg) . "'";
    }

    // Windows - complex escaping rules, fall back to PHP's implementation
    // TODO: Implement proper Windows escaping
    return \escapeshellarg($arg);
}
